within BuildingControlLib.BuildingControl.VDI3813;
package ActuatorFunctions "Actuator functions referring to VDI3813 directive"
      extends Modelica.Icons.VariantsPackage;






annotation (preferredView="info",Documentation(info="<html>
<p>This package contains actuator functions described in VDI 3813 <a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1]</a>: </p>
<p>&QUOT;<i>Actuator functions</i> (Figure 11) convert input information originating from operator or application functions to physical quantities appropriate to their output interface. They thus represent the physical outputs of the automation system to the environment. As is the case with sensors, the informative representation takes the form of function blocks showing the input information and the corresponding physical output. Additionally, actuator functions supply output information in terms of the current manipulated value of the physical interface.&QUOT; <a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1, section 6.2.1, p. 17]</a></p>
<p><b>Fig. 1: </b>UML class diagramm of the <i>actuator functions</i> basic design idea.<a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1, section 6.2.1, p. 17]</a></p>
<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\"><tr>
<td><p><img src=\"modelica://BuildingControlLib/Resources/Images/docUMLStr_ActuatorFunctionConcept.png\" alt=\"docUMLStr_ActuatorFunctionConcept.png\"/> </p></td>
</tr>
</table>
<p><br><b>Fig. 2: </b>UML class diagramm of the <i>actuator functions </i>planned for implementation.<a href=\"modelica://BuildingControlLib.UsersGuide.References\">[1, section 6.2.1, p. 17]</a></p>
<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\"><tr>
<td><p><img src=\"modelica://BuildingControlLib/Resources/Images/docUMLStr_ActuatorFunctions.png\" alt=\"docUMLStr_ActuatorFunctions.png\"/> </p></td>
</tr>
</table>
</html>", revisions="<html>
<ul>
<li>March 07, 2017&nbsp; by Georg Ferdinand Schneider &amp; Georg Ambrosius Pe&szlig;ler:<br>Implemented.</li>
</ul>
</html>"));
end ActuatorFunctions;
